require( "scripts/style.lua" );


MyDinerTitleFont = {
  standardFont,
  30,
  BlackColor
};

MyDinerCategoryFont = {
  standardFont,
  35,
  BlackColor
};

NewItemStyle =
{
	parent=DefaultStyle,
	image="mydinerui/newitem",
};

MyDinerBigButtonFont = 
{
  standardFont,
  24,
  BlackColor
};

MyDinerSmallButtonFont = 
{
  standardFont,
  16,
  BlackColor
};

MyDinerPlayButton = 
{
	"mydinerui/playdiner_button_a",
	"mydinerui/playdiner_button_b",
	"mydinerui/playdiner_button_c",
};

MyDinerPlayButtonFont = 
{
  standardFont,
  16,
  BlackColor
};

MyDinerShuffleButton = 
{
	"mydinerui/shuffle_button_a",
	"mydinerui/shuffle_button_b",
	"mydinerui/shuffle_button_c",
};

MyDinerShuffleButtonFont = 
{
  standardFont,
  16,
  BlackColor
};

MyDinerShareButtonGraphics = 
{
	"mydinerui/button_left-share_a",
	"mydinerui/button_left-share_b",
	"mydinerui/button_left-share_c",
};

MyDinerShareButtonFont = 
{
  standardFont,
  16,
  BlackColor
};

ShareTitleFont = 
{
  standardFont,
  32,
  BlackColor
};

RecentTitleFont = 
{
  standardFont,
  26,
  BlackColor
};

StoreTitleFont = 
{
  standardFont,
  32,
  BlackColor
};




DinerButtonStyle =
{
	parent=DefaultStyle,
	font=MyDinerBigButtonFont,
	graphics={"mydinerui/mydiner_button1_a", "mydinerui/mydiner_button1_b", "mydinerui/mydiner_button1_c"},
	type = kPush,
	xoffset = 0,
	yoffset = 0,
};

RenameButtonStyle =
{
	parent=DefaultStyle,
	font=StandardBorderButtonFont,
	graphics={"mydinerui/rename_button_a", "mydinerui/rename_button_b", "mydinerui/rename_button_c"},
	xoffset = -1,
	yoffset = 2,
	type = kPush,
	parent=DefaultStyle,
};




DinerArrowLeftButtonStyle = ClosetArrowLeftButtonStyle;

DinerArrowRightButtonStyle = ClosetArrowRightButtonStyle;



kLeftButtonX = 41;
kLeftButtonY = 60;
kLeftButtonSpacing = 50;

kRightButtonX = 635;
kRightButtonY = 69;
kRightButtonSpacing = 50;


kIconXPos = 160;
kIconXSpacing = 120;

MakeDialog
{
	x = 0,
	y = 0,
	w = 800,
	h = 600,
	fit = false,
	

	
	Bitmap
	{ 
		name="backgroundimage",
		image="mydinerui/mydiner_bg",	
		fit = false,
		
		AutoFitText
		{
			x=225,y=0,
			w=351,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			font = MyDinerTitleFont,
			label = 'mydiner',
			name = 'mydinername'
		},
		
		Bitmap
		{
			x = 0, y = 190,
			image = 'mydinerui/mydiner_sharepanel',
			Text
			{
				x = 25, w = kMax,
				y = 15, h = 35,
				label = 'md_share',
				font = MyDinerCategoryFont,
				flags = kHAlignLeft + kVAlignTop				
			},
			
			Text
			{
				x = 25, w = kMax,
				y = 51, h = 150,
				font = MenuNewFont,
				label = 'md_share_features',
				flags = kHAlignLeft + kVAlignTop
			},
			
			Bitmap
			{
				 x = 15, y = 51,
				 scale = 0.3,
				 image = 'mydinerui/newitem'
			},
			
			Bitmap
			{
				x = 15, y = 67,
				scale = 0.3,
				image = 'mydinerui/newitem'
			},
			SetStyle(DinerButtonStyle);
			Button
			{
				x = 0, y = 97,
				graphics = MyDinerShareButtonGraphics,
				font = MyDinerSmallButtonFont,
				name = 'share';
				label = 'md_share_now';
				command =
					function()
						MetricEvent(eMyDinerShare);
						if (LoginSystemEnabled()) then
							SetBoolSetting('todolist_share', true);
							SubmitContent();
						else
							DisplayDialog{
								'scripts/ok.lua', 
								body ='login_mpnotenabled',
								title = ''
							};
						end
					end
			},
		},
		
		Bitmap
		{
			x = 0, y = 0,
			image = 'mydinerui/mydiner_storepanel',
			
			Text
			{
				x = 0, w = kMax-40,
				y = 20, h = 50,
				font = StoreTitleFont,
				label = 'md_store',
				flags = kHAlignCenter + kVAlignTop
			},
			
		};
		
		Bitmap
		{
			x = 627, y = 0,
			image = 'mydinerui/mydiner_recentdiners',
			Text
			{
				x = 20, w = kMax,
				y = 20, h = 50,
				font = RecentTitleFont,
				label = 'md_recent',
				flags = kHAlignCenter + kVAlignTop
			},
			
		};
		
		
		Bitmap
		{
			x = 0, y = 331,
			image = 'mydinerui/mydiner_mainmenupanel',
			
			SetStyle(DinerButtonStyle);
			Button
			{
				x = 1;
				y = 23;
				name = 'done';
				font = MyDinerSmallButtonFont;
				label = 'md_done';
				command =
					function()
						SaveSettings();
						SaveThumbnail();
						SetRestartScreen(GetMainMenuScript());
						if (MyDinerChanged()) then
							if (GetStrSetting('md_dontaskagain', 'false') == 'true') then
								result = 'no';
							else
								result = DisplayDialog { 
									"scripts/yesno.lua", 
									body ="md_wanttoshare",
									title = "" ,
									donotshow='md_dontaskagain',
								};
							end
							if (result == 'no') then
								PopModal("scripts/mydiner.lua");
							else
								if (LoginSystemEnabled()) then
									SubmitContent();
								else
									DisplayDialog{
										'scripts/ok.lua', 
										body ='login_mpnotenabled',
										title = ''
									};
								end
							end
						else
							PopModal("scripts/mydiner.lua");
						end
						
					end
			};
		},
		
		
		
		
		
		
		SetStyle(DefaultStyle);
		Button
		{
			x = 350;
			y = 578;
			name = 'shuffle';
			label = 'md_shuffle';
			font = MyDinerShuffleButtonFont,
			graphics = MyDinerShuffleButton,
			command =
				function()
					RecordCurrentSettings();
					shuffleResult = 'choice2';				
					while (shuffleResult == 'choice2') do
						Randomize();
						shuffleResult = DisplayDialog { 
							"scripts/threechoices.lua", 
							body ="md_shufflequestion",
							title = "",
							choice1label="md_keepshuffle",
							choice2label="md_shuffleagain",
							choice3label="md_cancelshuffle",
							yloc = 380,
						};
					end
					if (shuffleResult == 'choice3') then
						RestoreCurrentSettings();
					end
					
				end
		};
		
		SetStyle(DinerButtonStyle);
		
		
		
		
		
		
		
		
		
	
		
		
		SetStyle(RenameButtonStyle);
		Button
		{
			x = 350;
			y = 39;
			name = 'rename';
			label = 'md_rename';
			command =
				function()
					name = MyDinerEnterTextDialog(GetMyDinerName());
					if (not(name == nil)) then
						ChangeMyDinerName(name);
						SetWindowText('mydinername', GetMyDinerName());
					end
				end
		};
		
		
		MyDinerEditor
		{
			x = 169,
			y = 67,
			w = 460,
			h = 345,
			teaserx = 22,
			teasery = 45,
			teaserw = 110,
			teaserh = 115,
			teaser2x = 668,
			teaser2y = 45,
			teaser2w = 116,
			teaser2h = 362,
			iconXPos = kIconXPos,
			iconXSpacing = kIconXSpacing,
			iconY1 = 520,
			iconY2 = 150,
			
		};
		
		Text
		{
			x=150,y=430,
			w=498,h=38,
			flags = kHAlignCenter + kVAlignCenter,
			font = MyDinerCategoryFont,
			label = 'md_walls',
			name = 'mydinercategory'
		},
		
		SetStyle(NewItemStyle);
		Bitmap{name="new0";x=(kIconXPos-69) + (kIconXSpacing * 0);y=505;};
		Bitmap{name="new1";x=(kIconXPos-69) + (kIconXSpacing * 1);y=505;};
		Bitmap{name="new2";x=(kIconXPos-69) + (kIconXSpacing * 2);y=505;};
		Bitmap{name="new3";x=(kIconXPos-69) + (kIconXSpacing * 3);y=505;};
		Bitmap{name="new4";x=(kIconXPos-69) + (kIconXSpacing * 4);y=505;};
		SetStyle(DinerArrowLeftButtonStyle);
		Button
		{
			x = 35,
			y = 505,
			name = 'iconleft',
			command=
				function()
					AdvanceIcons(-1);
				end
			
		};
		
		Button
		{
			x = 180,
			y = 432,
			name = 'categoryleft',
			command=
				function()
					AdvanceCategory(-1);
				end
			
		};
		
		SetStyle(DinerArrowRightButtonStyle);
		Button
		{
			x = 728,
			y = 505,
			name = 'iconright',
			command=
				function()
					AdvanceIcons(1);
				end
		};
		
		Button
		{
			x = 585,
			y = 432,
			name = 'categoryright',
			command=
				function()
					AdvanceCategory(1);
				end
			
		};

		
		Button
		{
			x = 350;
			y = 393;
			name = 'playdiner',
			label = 'md_playdiner',
			font = MyDinerPlayButtonFont,
			graphics = MyDinerPlayButton,
			hflip = true,
			command = 
				function()
					MetricEvent(eMyDinerPlay);
					SaveSettings();
					SaveThumbnail();
					result = DisplayDialog { 
						"scripts/threechoices.lua", 
						body ="md_playquestion",
						title = "",
						choice1label="md_playendless",
						choice2label="md_playmultiplayer",
						choice3label="md_playcancel",
						popthrough = true 
					};
					if (result == 'choice1') then
						SetMultiplayerLevelTestMode(false);
						SetMultiplayer("single");
						SetCurrentGameMode(1);
						ForceMyWaiterCreation(true);
						DoModal('scripts/choosedifficulty.lua');
					elseif (result == 'choice2') then
						SetGlobalStrSetting('mplaunchhint','mydiner');
						LaunchMPEntry();
					else
						-- Do nothing
					end
					
				end
		};
		
		MovingWindow
		{
			name="mydinerplaytray",
			x=670,y=477,
			dirX = 4,
			dirY = 0,
			startoff = 1,
			onDelay = 0,
			
			Bitmap
			{
				x = 0,
				y = 0,
				image = "mydinerui/play_tray",
				
				
				SetStyle(DinerButtonStyle);
				
				
				
				
			};
			
		};
		
		
		
		
		
		
		
		
		SetStyle(DefaultStyle);
	}
}

StopMainMenuMusic();
SetCurrentChoiceMode(0);
SetCurrentGameMode(1);
SetWindowText('mydinername', GetMyDinerName());
SetRestartScreen("scripts/mydiner.lua");
SetMultiplayer("single");

SetBoolSetting('todolist_mydiner', true);

if (GetSessionSetting('launchugcrecent') == 'true') then
	GetContent();
end

EnforceOnlineBuild();